<?php defined('SYSPATH') or die('No direct script access.');

class Model_Log extends ORM {
    protected $_primary_key = 'id';
    protected $_table_name = 'logs';
    protected $_table_columns = [
        'id' => NULL,
        'user_id' => NULL,
        'user_ip' => NULL,
        'query' => NULL,
        'count_find_clients' => NULL,
        'time_start' => NULL,
        'time_total' => NULL,
        'time_find_clients' => NULL,
        'time_find_logposts' => NULL,
        'time_find_logposts_db' => NULL,
        'count_find_logposts' => NULL,
        'time_client_filter' => NULL,
        'count_client_filter' => NULL,
    ];

    protected $_belongs_to = [
        'user' => [
            'model'       => 'user',
            'foreign_key' => 'user_id',
        ]
    ];

    public static function createLog(array $query, $time_start)
    {
        $log = ORM::factory('Log');
        $log->user_ip = Request::$client_ip;
        $log->user_id = Auth::instance()->get_user()->id;
        if (isset($query['onlineClientsIds'])) {
            $query['onlineClientsIds'] = '[(' . count($query['onlineClientsIds']) . ')]';
        }
        if (Arr::get($query, 'user_query')) {
            $query['user_query'] = ORM::factory('User_Query', $query['user_query'])->name;
        }
        if (Arr::get($query, 'mini')) {
            unset($query['mini']);
        }
        $log->query = json_encode(array_filter($query));
        $log->time_start = $time_start;
        $log->create();
        
        return $log;
    }
    
    public function getCountClientFilterFormatted($count_client_filter){
        if (floatval($count_client_filter) < 500) {
            return $count_client_filter;
        } elseif (floatval($count_client_filter) < 1000) {
            return '<span class="text-danger">' . $count_client_filter . '</span>';
        } else {
            return '<span class="text-danger"><strong>' . $count_client_filter . '</strong></span>';
        }
    }

    public function getTimeTotalFormatted($time_total){
        if (floatval($time_total) < 10) {
            return $time_total;
        } elseif (floatval($time_total) < 60) {
            return '<span class="text-danger">' . $time_total . '</span>';
        } else {
            return '<span class="text-danger"><strong>' . $time_total . '</strong></span>';
        }
    }
    
    public function getParallelQueries($id)
    {
        $parallelQueries = DB::select([DB::expr('COUNT("OverlappingQueries"."log1_id")'), 'count'])
            ->select([DB::expr('SUM(LEAST("OverlappingQueries"."log1_end", "OverlappingQueries"."log2_end") - GREATEST("OverlappingQueries"."log1_start", "OverlappingQueries"."log2_start"))'), 'overlap'])
            ->from([
                DB::select(['log1.id', 'log1_id'])
                    ->select([DB::expr('EXTRACT(EPOCH FROM log1.time_start)'), 'log1_start'])
                    ->select([DB::expr('EXTRACT(EPOCH FROM log1.time_start) + log1.time_total'), 'log1_end'])
                    ->select([DB::expr('EXTRACT(EPOCH FROM log2.time_start)'), 'log2_start'])
                    ->select([DB::expr('EXTRACT(EPOCH FROM log2.time_start) + log2.time_total'), 'log2_end'])
                    ->from([ORM::factory('Log')->table_name(), 'log1'])
                    ->join([ORM::factory('Log')->table_name(), 'log2'])
                    ->on('log1.id', '<>', 'log2.id')
                    ->on(DB::expr('EXTRACT(EPOCH FROM log1.time_start) <= EXTRACT(EPOCH FROM log2.time_start) + log2.time_total'), 'AND', DB::expr('EXTRACT(EPOCH FROM log1.time_start) + log1.time_total >= EXTRACT(EPOCH FROM log2.time_start)'))
                    ->where('log1.id', '=', $id),
                'OverlappingQueries'
            ])
            ->group_by('OverlappingQueries.log1_id')
            ->execute();
        
        if (count($parallelQueries) > 0) {
            $parallelQueries = $parallelQueries[0];
        } else {
            $parallelQueries = [
                'count' => 0,
                'overlap' => 0,
            ];
        }
        
        return $parallelQueries['count'] . ' / ' . substr($parallelQueries['overlap'], 0, 8);
    }
    
}

